VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Scheduler"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
' An industrial-strength scheduler would not hold all the events in memory. But, oh well.

Private m_SchedIncrement As Integer
' Contains the actual SchedEvents. Don't write to it directly.
Private m_Schedule(0 To 96) As SchedEvent
Private m_CurSchIndex As Integer
Private m_CurSchLimit As Integer

' Get fast lookup, minimize the cost of the array. Holds locations of SchedEvents.
Private m_Registry(1 To 24, 1 To 60, 1 To 60) As Integer

Public Property Get Schedule() As SchedEvent
    Schedule = m_Schedule
End Property

Public Property Get CurSchIndex() As Integer
    CurSchIndex = m_CurSchIndex
End Property

Public Property Get CurSchLimit() As Integer
    CurSchLimit = m_CurSchLimit
End Property

Public Sub Init()
    m_CurSchIndex = 0
    m_CurSchLimit = 96
    Dim i, j, k As Integer
    
    'm_SchedSizeIncrement = 48

    For i = 1 To 24
        For j = 1 To 60
            For k = 1 To 60
                m_Registry(i, j, k) = -1
            Next k
        Next j
    Next i
End Sub

Public Function AddEvent(hr As Integer, ByVal min As Integer, ByVal sec As Integer, _
    eventType As SETypes, eventData As String) As Boolean

    Dim eventloc As Integer
    eventloc = m_Registry(hr, min, sec)
    
    If eventloc = -1 Then
        If Not m_CurSchIndex >= m_CurSchLimit Then
            Dim newEvent As SchedEvent
            SEConstruct newEvent, eventType, eventData
            
            m_Registry(hr, min, sec) = m_CurSchIndex
            m_Schedule(m_CurSchIndex) = newEvent
            
            m_CurSchIndex = m_CurSchIndex + 1
            AddEvent = True ' Successful
        Else
            AddEvent = False ' Too full.
        End If
    Else
        AddEvent = AddEvent ' Something already at that time.
    End If
            
End Function
